/**
Optimal F Library, version 1.00

Copyright 2018, Anthony J. Garot
MQL5 Profile: https://www.mql5.com/en/users/tonegarot
My website: http://www.garot.com/trading/

This Test stub file must reside in the Scripts/ directory.

Output goes to the [Experts tab], not the [Journal] tab.
*/

#property copyright "Copyright 2018, Garot"
#property link      "http://www.garot.com/trading/"
#property version   "1.00"
#property strict

#include <clsOptimalF.mqh>

int OnStart()
{
	Print("-> Running test_GeometricMeanOptimalF");
	test_GeometricMeanOptimalF();

	return (INIT_SUCCEEDED);
}

void test_GeometricMeanOptimalF()
{
	COptimalF *mm=new COptimalF();

	// Not primed means to send back the default.
	if ( mm.GeometricMeanOptimalF() == GEOM_MEAN_DEFAULT_VALUE )
	{
		Print("Test passed");
	}
	else
	{
		Print("Not primed with trades. Test failed.");
	}

	// Add a single win and loss
	mm.AddProfitTrade(100.00);
	mm.AddProfitTrade(-100.00);
	if ( mm.GeometricMeanOptimalF() == GEOM_MEAN_DEFAULT_VALUE )
	{
		Print("Test passed");
	}
	else
	{
		Print("Opposite trades. Test failed.");
	}

	// Reset
	mm.ResetTradeCounts();

	// From the Mathematics of Money Management, pg. 16
	mm.AddProfitTrade(+9);
	mm.AddProfitTrade(+18);
	mm.AddProfitTrade(+7);
	mm.AddProfitTrade(+1);
	mm.AddProfitTrade(+10);
	mm.AddProfitTrade(-5);
	mm.AddProfitTrade(-3);
	mm.AddProfitTrade(-17);
	mm.AddProfitTrade(-7);
	if ( MathAbs(mm.GeometricMeanOptimalF() - 0.24) < DBL_EPSILON )
	{
		Print("Test passed");
	}
	else
	{
		Print("Bet series. Test failed.");
	}

	//unittest.assertEquals(__FUNCTION__,"bet series",0.240,NormalizeDouble(mm.GeometricMeanOptimalF(),3));

	delete(mm);			// destroy what you create
}

// -------------------------------------------------------------------------------------
